USE [EleriumClean]
GO

/****** Object:  Table [dbo].[StoreOrder]    Script Date: 10/3/2013 8:17:04 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[StoreOrder](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StoreCurrencyID] [int] NOT NULL,
	[StoreItemID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DateModified] [datetime] NOT NULL,
	[EmailAddress] [nvarchar](max) NULL,
	[ExchangeRate] [money] NOT NULL,
	[PricePerItem] [money] NOT NULL,
	[Quantity] [int] NOT NULL,
	[Status] [tinyint] NOT NULL,
	[SourceID] [int] NULL,
 CONSTRAINT [PK_StoreOrder] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

ALTER TABLE [dbo].[StoreOrder] ADD  CONSTRAINT [DF_StoreOrder_DateCreated]  DEFAULT (getutcdate()) FOR [DateCreated]
GO

ALTER TABLE [dbo].[StoreOrder] ADD  CONSTRAINT [DF_StoreOrder_DateModified]  DEFAULT (getutcdate()) FOR [DateModified]
GO

ALTER TABLE [dbo].[StoreOrder]  WITH CHECK ADD  CONSTRAINT [FK_StoreOrder_StoreCurrency] FOREIGN KEY([StoreCurrencyID])
REFERENCES [dbo].[StoreCurrency] ([ID])
GO

ALTER TABLE [dbo].[StoreOrder] CHECK CONSTRAINT [FK_StoreOrder_StoreCurrency]
GO

ALTER TABLE [dbo].[StoreOrder]  WITH CHECK ADD  CONSTRAINT [FK_StoreOrder_StoreItem] FOREIGN KEY([StoreItemID])
REFERENCES [dbo].[StoreItem] ([ID])
GO

ALTER TABLE [dbo].[StoreOrder] CHECK CONSTRAINT [FK_StoreOrder_StoreItem]
GO

ALTER TABLE [dbo].[StoreOrder]  WITH CHECK ADD  CONSTRAINT [FK_StoreOrder_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO

ALTER TABLE [dbo].[StoreOrder] CHECK CONSTRAINT [FK_StoreOrder_User]
GO

ALTER TABLE [dbo].[StoreOrder]  WITH CHECK ADD  CONSTRAINT [CK_StoreOrder_Status] CHECK  (([Status]=(1) OR [Status]=(2) OR [Status]=(3) OR [Status]=(4)))
GO

ALTER TABLE [dbo].[StoreOrder] CHECK CONSTRAINT [CK_StoreOrder_Status]
GO

EXEC sys.sp_addextendedproperty @name=N'EnumValues', @value=N'Placed=1;Fulfilled=2;Cancelled=3;Refunded=4;' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StoreOrder', @level2type=N'COLUMN',@level2name=N'Status'
GO


